#include "Length_unit.h"

#include "Text.h"
#include "Flaw.h"

namespace MM
{
Unit * Length_unit::
clone () const
{
    Length_unit *result   = new Length_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Length_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "A")
        return A ();

    else if (current_type == "bohr")
        return bohr ();

    else if (current_type == "m")
        return m ();

    else if (current_type == "nm")
        return nm ();

    else if (current_type == "cm")
        return cm ();

//    else if (current_type == "km")
//        return km ();

    else
        FLAW (Text() + "Unknown Length_unit '" + current_type + "'.");
}

void Length_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "A")
        set_A (new_value);

    else if (current_type == "bohr")
        set_bohr (new_value);

    else if (current_type == "m")
        set_m (new_value);

    else if (current_type == "nm")
        set_nm (new_value);

    else if (current_type == "cm")
        set_cm (new_value);

//    else if (current_type == "km")
//        set_km (new_value);

    else
        FLAW (Text() + "Unknown Length_unit '" + current_type + "'.");
}

Text const & Length_unit::
type (int n)  const
{
    static const Text m    = "m";
    static const Text cm   = "cm";
//    static const Text km   = "km";
    static const Text nm   = "nm";
    static const Text A    = "A";
    static const Text bohr = "bohr";

    switch (n)
    {
    case 0: return m;
    case 1: return cm;
//    case 2: return km;
    case 2: return nm;
    case 3: return A;
    case 4: return bohr;

    default: FLAW ("Out of range.");
    }
}

}//MM

