#ifndef LENGTH_UNIT_H
#define LENGTH_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Length_unit : public Unit
{
    double  value_;     // m

public:
    explicit        Length_unit () : value_(0.) {set_current_type("A");}
    Unit *          clone () const;

    double          m       () const        {return   value_;}
    Length_unit &   set_m   (double value)  {value_ = value; return *this;}

    double          cm      () const    {return       100. *value_;}
    Length_unit &   set_cm  (double value)
                        {value_ = 1./ 100. *value; return *this;}

    //double        km      () const    {return 1./ 1000.  *value_;}
    //Length_unit & set_km  (double value)
    //                  {value_  =  1000.  *value; return *this;}

    double          nm      () const    {return       1e9  *value_;}
    Length_unit &   set_nm  (double value)
                        {value_ = 1./ 1e9  *value; return *this;}

    double          A       () const    {return       1e10 *value_;}
    Length_unit &   set_A   (double value)
                        {value_ = 1./ 1e10 *value; return *this;}

    double          bohr    () const    {return 1./ 5.2917724924e-11 *value_;}
    Length_unit &   set_bohr(double value)
                        {value_ =   5.2917724924e-11 *value; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const     {return 5;}
    Text const& type (int n)  const;
};

}//MM

#endif //LENGTH_UNIT_H
