#include "Mass_unit.h"

#include "Flaw.h"

namespace MM
{

Mass_unit::Mass_unit ()
:
    value_(0.)
{
    set_current_type("amu");
}

Unit *  Mass_unit::
clone () const
{
    Mass_unit *result     = new Mass_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Mass_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "amu")
        return amu ();

    else if (current_type == "kg")
        return kg ();

    else if (current_type == "me")
        return me ();

    else
        FLAW (Text() + "Unknown Mass_unit '" + current_type + "'.");
}

void Mass_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "amu")
        set_amu (new_value);

    else if (current_type == "kg")
        set_kg (new_value);

    else if (current_type == "me")
        set_me (new_value);

    else
        FLAW (Text() + "Unknown Mass_unit '" + current_type + "'.");
}

Text const& Mass_unit::
type (int n) const
{
    static const Text amu = "amu";
    static const Text kg   = "kg";
    static const Text me   = "me";

    switch (n)
    {
    case 0: return amu;
    case 1: return kg;
    case 2: return me;
    default: FLAW ("Out of range.");
    }
}

}//MM
