#ifndef MASS_UNIT_H
#define MASS_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Mass_unit : public Unit
{
    double  value_;     // amu

public:
    explicit            Mass_unit ();
    Unit *              clone () const;

    double              amu     () const        {return   value_;}
    Mass_unit &         set_amu (double value)  {value_ = value; return *this;}

    double              kg      () const        {return  1.6605402e-27*value_;}
    Mass_unit &         set_kg (double value)
                                    {value_ = value/1.6605402e-27; return *this;}
    // electron rest mass
    double              me      () const        {return  kg()/9.1093826e-31;}
    Mass_unit &         set_me (double value)
                                    {set_kg(value/9.1093826e-31); return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 3;}
    Text const& type (int n)  const;
};

}//MM

#endif //MASS_UNIT_H
