#ifndef MEASURE_GEOMETRY_H
#define MEASURE_GEOMETRY_H

namespace MM
{
class Text;
class Point_3D;
class Unit;
class Length_unit;
class Angle_unit;

class Measure_geometry
{
public:
    virtual                 ~Measure_geometry () { }

    virtual void            prepend_point () =0;
    virtual void            append_point  () =0;
    
    virtual bool            is_active  (int point) const =0;
    virtual void            set_active (int point, bool on) =0;
    virtual int             active_count () =0;

    virtual Text const &    type                   (int pnt) const =0;
    virtual void            set_atom_type          (int pnt, int atom_number)=0;
    virtual void            set_mass_center_type   (int pnt, int mol_number) =0;
    virtual void            set_space_position_type(int pnt, Point_3D const&)=0;

    virtual void            get_space_position     (int pnt, Point_3D &)const=0;
    virtual void            set_space_position     (int pnt, Point_3D const&)=0;

    virtual int             number             (int point) const =0;
    virtual void            set_number         (int point, int number) =0;

    virtual void            get_info (Text & result) =0;
    virtual void            get_points_info (Text & result) =0;

    virtual Text const &    parameter_type_name () const =0;
    virtual Unit const &    parameter     ()       const =0;
    virtual void            set_parameter (Unit const &) =0;
    virtual void            add_parameter (Unit const &) =0;
    virtual void            set_parameter (double) =0;
    virtual void            add_parameter (double) =0;

    virtual Length_unit const & last_length         () const =0;
    virtual Angle_unit  const & last_angle          () const =0;
    virtual Angle_unit  const & last_dihedral_angle () const =0;

    virtual bool            support_restraint () const =0;
    virtual void            new_distance_restraint (double R_eqv,
                                                    double K_r) const = 0;

    static int              type_counter ();
    static Text const &     type_name (int index);
    static int              type_index (Text const & name);
};

}//MM

#endif //MEASURE_GEOMETRY_H
