#ifndef COLLECT_DENSITY_H
#define COLLECT_DENSITY_H

#ifndef COLLECT_SCALAR_H
#include "Collect_scalar.h"
#endif

#ifndef DENSITY_H
#include "Density.h"
#endif

namespace MM
{

class Collect_density : public Collect_scalar
{
    Density             density_;

public:
    explicit            Collect_density (Model & model, Text in)
    :   Collect_scalar(model, in), density_(model)
    {
       new_file_presentation (Path::report() +"dyn_Density.xls");
    }

    Monitor *           clone (Atom_group & atom_group, Text const & /*args*/, Text in) const
    {return new Collect_density (dynamic_cast <Model &> (atom_group), in);}

    Text                title      () const {return "Density";}
    Text                class_name () const {return "Collect_density";}
    virtual double      extract_current_value () {return density_.value();}
};

}//MM

#endif //COLLECT_DENSITY_H
