#include "Collect_distance.h"

#include "Atom.h"
#include "Atom_group.h"
#include "Point_3D.h"
class Monitor;

namespace MM
{

Collect_distance::
Collect_distance (Atom_group & atom_group, Text in)
:
    Collect_scalar (atom_group, in)
{
    REQUIRE ("", atom_group.atom_count () == 2);
}

Monitor * Collect_distance::
clone (Atom_group & atom_group, Text const &, Text in) const
{
    REQUIRE ("", atom_group.atom_count () == 2);
    return new Collect_distance (atom_group, in);
}

double Collect_distance::
extract_current_value ()
{
    return atom_group().atom(0).position(). distance
          (atom_group().atom(1).position());
}

}//MM
