#include "Collect_energy.h"

#include "Path.h"
#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"

#include "Collect_scalar_to_file.h"
#include "Model.h"
#include "Model_kit.h"
#include "Arbitrary_atom_group.h"

#include "Create.h"
class Monitor;

namespace MM
{
/*namespace
{
    static Arbitrary_atom_group     no_model;
}//*/

Collect_energy * prototype_of_collect_energy = new Collect_energy (Prototype());

Collect_energy::
Collect_energy (Prototype const &)
:
    Collect_scalar (nil<Atom_group>(), "Prototype")
{
    adopt_prototype (this);
}

Collect_energy::
Collect_energy (Atom_group & atom_group, Text in)
:
    Collect_scalar (atom_group, in)
{
//    adopt_file_presentation (new Collect_scalar_to_file
//        (Path::working() + "_energy.xls", *this));

//    new_graph_presentation ("Energy");
    new_file_presentation (Path::report() +"dyn_Energy.xls");
}

double Collect_energy::
extract_current_value ()
{
    double kinetic_energy = 0.;
    //double potential_energy = 0.;

    double potential_energy = dynamic_cast <Model &> (atom_group()).kit().  //fix Model
        interaction ().potential ();

    for (int i=0;  i<atom_group().atom_count();  ++i)
    {
        Atom const & current_atom = atom_group().atom (i);

        double velocity_2 = current_atom.kit().velocity().length_2();
        kinetic_energy += current_atom.mass() * velocity_2;

        //potential_energy += current_atom.kit().energy_terms().potential_energy();
    }

    kinetic_energy /= 2.;

    return potential_energy + kinetic_energy;
}

Monitor * Collect_energy::
clone (Atom_group & atom_group, Text const &, Text in) const
{
    return new Collect_energy (atom_group, in);
}

}//MM


