#include "Collect_intermolecular_energy.h"

#include "Model.h"
#include "Model_kit.h"
#include "Path.h"

namespace MM
{

Collect_intermolecular_energy * prototype_of_intermolecular_collect_energy
    = new Collect_intermolecular_energy (Prototype());

Collect_intermolecular_energy::
Collect_intermolecular_energy (Prototype const & )
:
    Collect_scalar (nil<Atom_group>(), "Prototype")
{
    adopt_prototype (this);
}

Collect_intermolecular_energy::
Collect_intermolecular_energy (Atom_group & atom_group, Text in)
:
    Collect_scalar (atom_group, in)
{
    new_file_presentation (Path::report() +"dyn_Intermolecular_Pot.xls");
}

Monitor * Collect_intermolecular_energy::
clone (Atom_group & atom_group, Text const & /*args*/, Text in) const
{
    return new Collect_intermolecular_energy (atom_group, in);
}


double Collect_intermolecular_energy::
extract_current_value ()
{
    return dynamic_cast <Model &> (atom_group()).kit().
        interaction ().common().last_intermolecular_potential ();
}

}//MM
