#include "Collect_kinetic_energy.h"

#include "Path.h"
#include "Atom.h"
#include "Atom_group.h"
#include "Atom_kit.h"

#include "Create.h"
//class Monitor;

namespace MM
{

Collect_kinetic_energy * prototype_of_collect_kinetic_energy
    = new Collect_kinetic_energy (Prototype());

Collect_kinetic_energy::
Collect_kinetic_energy (Prototype const &)
:
    Collect_scalar (nil<Atom_group>(), "Prototype")
{
    adopt_prototype (this);
}

Collect_kinetic_energy::
Collect_kinetic_energy (Atom_group & atom_group, Text in)
:
    Collect_scalar (atom_group, in)
{
//    adopt_file_presentation (new Collect_scalar_to_file
//        (Path::working() + "_energy.xls", *this));

//    new_graph_presentation ("Energy");
    new_file_presentation (Path::report() +"dyn_Kinetic_energy.xls");
}

Monitor * Collect_kinetic_energy::
clone (Atom_group & atom_group, Text const &, Text in) const
{
    return new Collect_kinetic_energy (atom_group, in);
}


double Collect_kinetic_energy::
extract_current_value ()
{
    double kinetic_energy = 0.;

    for (int i=0;  i<atom_group().atom_count();  ++i)
    {
        Atom const & current_atom = atom_group().atom (i);
        double velocity_2 = current_atom.kit().velocity().length_2();
        kinetic_energy += current_atom.mass() * velocity_2;
    }

    kinetic_energy /= 2.;
    return kinetic_energy;
}

}//MM
