#ifndef COLLECT_PHASE_TRAJECTORY_H
#define COLLECT_PHASE_TRAJECTORY_H

#ifndef MONITOR_FRAME_H
#include "Monitor_frame.h"
#endif

#ifndef TEXT_OUTPUT_H
//#include "Text_output.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#include <fstream>

namespace MM
{
class Atom_group;
class Text;
class Prototype;

class Collect_phase_trajectory : public Monitor_frame
{
    Atom_group &            group_;
    std::ofstream           out_;
    //Own<Text_output>        out_;
    //int                     counter_;
    int                     precision_;

public:
    explicit Collect_phase_trajectory 
        (Atom_group & group, Text const & filename, int precision, Text in);

    // Constructor for prototype only.
    Collect_phase_trajectory (Prototype const &);

    Text            title      () const {return "Phase trajectory";}
    virtual Text                value () const {return "";}

    Text            class_name () const;
    Monitor *       clone (Atom_group & atom_group, Text const & args, Text in) const;

protected:
    void                    handle_execute ();
    Monitor_presentation *  create_file_presentation  (Text const& filename);
    Monitor_presentation *  create_graph_presentation (Text const& graphname);
};

}//MM

#endif //COLLECT_PHASE_TRAJECTORY_H

