#include "Collect_pressure.h"

#include "Path.h"
#include "Pressure_unit.h"
#include "System_of_Units.h"

namespace MM
{
Collect_pressure::Collect_pressure (Model & model, Text in)
:
    Collect_scalar(model, in), pressure_(model)
{
    new_file_presentation (Path::report() +"dyn_Pressure.xls");
}

Monitor * Collect_pressure::
clone (Atom_group & atom_group, Text const & /*args*/, Text in) const
{
    return new Collect_pressure (dynamic_cast <Model &> (atom_group), in);
}

double Collect_pressure::
extract_current_value ()
{
    Pressure_unit value;
    System_of_Units::singleton().set_pressure (value, pressure_.value());
    return value.atm();
}

}//MM
