#ifndef COLLECT_SCALAR_TO_FILE_H
#define COLLECT_SCALAR_TO_FILE_H
class Monitor;

#ifndef COLLECT_SCALAR_PRESENTATION_H
#include "Collect_scalar_presentation.h"
#endif

#ifndef FILE_TEXT_OUTPUT_H
#include "File_text_output.h"
#endif

#ifndef COLLECT_SCALAR_H
#include "Collect_scalar.h"
#endif

namespace MM
{

class Collect_scalar_to_file : public Collect_scalar_presentation
{
    Text                        filename_;

public:
    explicit Collect_scalar_to_file (Text const& filename, Monitor & monitor)
    :
        Collect_scalar_presentation (monitor),
        filename_(filename)
    {
        handle_clear ();
        //File_text_output out(filename_);
        //out.line ("# \t A \t <A> \t rmsd");
    }

    char const *        title () const {return filename_.c_str();}
    void                show () {}

    virtual void            update ()
    {
        //REQUIRE ("", dynamic_cast <Collect_scalar *> (&monitor_) != 0);
        //Collect_scalar & data = static_cast <Collect_scalar &> (monitor_);

        //handle_clear ();
        //File_text_output out(filename_, "a");

        //if (data.has_values ())
        //{
        //    for (int i=0;  i<data.count();  ++i)
        //    {
        //        out.text ((i+1) * data.observation_period());
        //        out.text ("\t");
        //        out.text (data.value (i));
        //        out.text ("\t");
        //        out.text (data.average (i));
        //        out.text ("\t");
        //        out.line (data.rmsd (i));
        //        out.flush();
        //    }
        //}
        //else
        //{
        //    out.text (0);
        //    out.text ("\t");
        //    out.text (0);
        //    out.text ("\t");
        //    out.text (0);
        //    out.text ("\t");
        //    out.line (0);
        //    out.flush();
        //}
    }

    virtual void            add_data ()
    {
        REQUIRE ("", dynamic_cast <Collect_scalar *> (&monitor_) != 0);
        Collect_scalar & data = static_cast <Collect_scalar &> (monitor_);

        if (data.has_values ())
        {
            File_text_output out(filename_, "a");

            out.text (data.count()/* * data.observation_period()*/);
            out.text ("\t");
            out.text (data.last_value());
            out.text ("\t");
            out.text (data.last_block_10_value().c_str());
            out.text ("\t");
            out.text (data.last_block_100_value().c_str());
            out.text ("\t");
            out.text (data.average());
            out.text ("\t");
            out.text (data.rmsd());
            out.text ("\t");
            out.text (data.rmsd_10().c_str());
            out.text ("\t");
            out.line (data.rmsd_100().c_str());
            out.flush();
        }
        else
        {
        }
    }

    virtual void            handle_clear  ()
    {
        File_text_output out(filename_);
        out.line ("# \tA \t<A>10 \t<A>100 \t<A> \trmsd \trmsd10 \trmsd100");
    }
};

}//MM

#endif //COLLECT_SCALAR_TO_FILE_H
