#ifndef COLLECT_SCALAR_TO_GRAPH_H
#define COLLECT_SCALAR_TO_GRAPH_H

#ifndef COLLECT_SCALAR_TO_FILE_H
#include "Collect_scalar_to_file.h"
#endif

#ifndef GRAPH_H
#include "Graph.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

class Monitor;

namespace MM
{

class Collect_scalar_to_graph : public Collect_scalar_to_file
{
    Graph &                     graph_;
    Text                        graphname_;

public:
    explicit Collect_scalar_to_graph (Text const & graphname, Monitor & monitor)
    :
        Collect_scalar_to_file (Text("_") + graphname +".gnuplot.xls", monitor),
        graph_(Graph::get(graphname)),
        graphname_(graphname)
    {
//        graph_.show();
    }

    Text const &            graphname () const {return graphname_;}

    void                    show   ()               
    {
        //Collect_scalar_to_file::update ();
        graph_.show (*this);
    }
    
    virtual void            update ()               
    {
        if (graph_.is_on())
        {
            //Collect_scalar_to_file::update ();
            Collect_scalar_to_file::add_data ();
            graph_.update (*this);
        }
    }

    virtual void            add_data ()
    {
        //Collect_scalar_to_file::add_data ();
        update ();
    }

};

}//MM

#endif //COLLECT_SCALAR_TO_GRAPH_H
