#include "Collect_temperature.h"

#include "Atom.h"
#include "Atom_kit.h"
#include "Atom_group.h"
#include "System_of_Units.h"
#include "Path.h"
#include "Temperature.h"

namespace MM
{

Collect_temperature::
Collect_temperature (Atom_group & atom_group, Text in)
:
    Collect_scalar (atom_group, in)
{
//    new_graph_presentation ("temperature");
    new_file_presentation (Path::report() +"dyn_Temperature.xls");
}

Monitor * Collect_temperature::
clone (Atom_group & atom_group, Text const & /*args*/, Text in) const
{
    return new Collect_temperature (atom_group, in);
}
               
double Collect_temperature::
extract_current_value ()
{
    Temperature result (atom_group());
    return result.value();

/*    int     count = atom_group().atom_count();
    double  sum = 0.;

    for (int i=0;  i<count;  ++i)
    {
        Atom & atom = atom_group().atom (i);
        double mass = atom.mass();
        double velocity_2 = atom.kit().velocity().length_2();
        sum += mass * velocity_2;
    }

    //0.001987191 kcal mol-1 K-1 * 4.184  = 0.008 314 51 kJ mol-1 K-1
    double kB = System_of_Units::singleton().gas_constant();

    return  sum / (3. * count * kB);//*/
}

}//MM
