#ifndef GRAPH_H
#define GRAPH_H

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
class Text;
class Collect_scalar_to_graph;

class Graph : protected DbC
{
    Text                            name_;

    static Array_of_own <Graph>     global_graph_collection;//fix global_ to all

protected:
    explicit Graph (Text const & name) : name_(name) {}

public:
    virtual        ~Graph() {}

    static Graph &  get (Text const & name);

    Text const &    name   () const;
    virtual void    show   (Collect_scalar_to_graph &) =0;
    virtual void    update (Collect_scalar_to_graph &) =0;
    virtual bool    is_on () const =0;
};

}//MM

#endif //GRAPH_H
