#include "Monitor.h"

#include "Array_of_own.h"
#include "Text.h"
#include "Flaw.h"

namespace MM
{

namespace
{
    Array_of_own <Monitor> & prototype_list ()
    {
        static Array_of_own <Monitor>   instance;
        return instance;
    }
}

Monitor * Monitor::
create (Atom_group & atom_group, Text const & monitor, Text in)
{
    for (int i=0;  i<prototype_count();  ++i)
        if (monitor == prototype (i). class_name ())
            return prototype (i).clone (atom_group, monitor, in);

    FLAW (monitor + " - no such monitor." );
}
int Monitor::
prototype_count ()
{
    return prototype_list().size();
}
Monitor & Monitor::
prototype (int n)
{
    return prototype_list()[n];
}
void Monitor::
adopt_prototype (Monitor * monitor)
{
    prototype_list().push_back (monitor);
}

}//MM
