#ifndef MONITOR_H
#define MONITOR_H

#ifndef COMMAND_H
#include "Command.h"
#endif


namespace MM
{
class Text;
class Atom_group;

class Monitor: public Command
{
public:
    static Monitor *            create (Atom_group & atom_group,
                                        Text const & monitor,
                                        Text         in);
    static int                  prototype_count ();
    static Monitor &            prototype (int n);
    static void                 adopt_prototype (Monitor * monitor);

    virtual Monitor *           clone (Atom_group & atom_group,
                                       Text const & args,
                                       Text         in) const =0;

    virtual Text                class_name () const =0;
    virtual Text                title   () const =0;
    virtual Text                in      () const =0;
    virtual bool                is_on   () const =0;
    virtual void                turn_on (bool )   =0;
    virtual void                show    () =0;
    virtual void                update  () =0;
    virtual void                execute () =0;
    virtual void                clear   () =0;
    virtual int                 observation_period     () const =0;
    virtual void                set_observation_period (int p) =0;
};

}//MM


#endif //MONITOR_H
