#include "Monitor_frame.h"

//#include "Log.h"
#include "User.h"

#include <typeinfo>

namespace MM
{

void Monitor_frame::
execute ()
{
	++counter_;

    //if (is_on() && call_ % period_ == 0)
    if (is_on() && counter_ % period_ == 0)
    {
        ++collected_;
        //log () << "call_" << call_ << "  period_" << period_ << "\n";
        try
        {
            handle_execute();
        }
        catch(...)
        {
            Text message;
            message += " in Monitor_frame::execute\n";
            message += "class ";
            message += typeid(*this).name();
            to_user().fatal_error (message);
        }

    }
}

void Monitor_frame::
clear()
{
    collected_=0;
    counter_=0;

    for (int i=0;  i<presentation_.size();  ++i)
        //presentation_[i].clear (*this);
        presentation_[i].interface_for(this).handle_clear ();
}

int Monitor_frame::
observation_period () const
{
    return period_;
}

void Monitor_frame::
set_observation_period (int p)
{
    period_= p;
}

bool Monitor_frame::
has_file_presentation () const
{
    return file_presentation_ !=0;
}

bool Monitor_frame::
has_graph_presentation () const
{
    return graph_presentation_ !=0;
}

Monitor_presentation & Monitor_frame::
file_presentation ()
{
    REQUIRE ("", has_file_presentation ());
    return *file_presentation_;
}

Monitor_presentation const & Monitor_frame::
file_presentation () const
{
    REQUIRE ("", has_file_presentation ());
    return *file_presentation_;
}

Monitor_presentation & Monitor_frame::
graph_presentation ()
{
    REQUIRE ("", has_graph_presentation ());
    return *graph_presentation_;
}

Monitor_presentation const & Monitor_frame::
graph_presentation () const
{
    REQUIRE ("", has_graph_presentation ());
    return *graph_presentation_;
}

void Monitor_frame::
new_file_presentation (Text const& filename)
{
    adopt_file_presentation (create_file_presentation (filename));
}

void Monitor_frame::
adopt_file_presentation (Monitor_presentation *pr)
{
    if (has_file_presentation())
        eliminate_presentation (file_presentation());

    file_presentation_ = pr;
    adopt_presentation (pr);
}

void Monitor_frame::
new_graph_presentation (Text const& /*graphname*/)
{
    //fix adopt_graph_presentation (create_graph_presentation (graphname));
}

void Monitor_frame::
adopt_graph_presentation (Monitor_presentation *pr)
{
    if (has_graph_presentation())
        eliminate_presentation (graph_presentation());

    graph_presentation_ = pr;
    adopt_presentation(pr);
}

void Monitor_frame::
adopt_presentation (Monitor_presentation *pr)
{
    presentation_.adopt (pr);
}

void Monitor_frame::
eliminate_presentation (Monitor_presentation &pr)
{
    presentation_.remove (pr);

    if (&pr == (Monitor_presentation *)file_presentation_)
        file_presentation_ = 0;

    if (&pr == (Monitor_presentation *)graph_presentation_)
        graph_presentation_ = 0;
}

}//MM




