#ifndef MONITOR_FRAME_H
#define MONITOR_FRAME_H

#ifndef DISABLING_H
#include "Disabling.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

#ifndef MONITOR_PRESENTATION_H
#include "Monitor_presentation.h"
#endif

#ifndef MONITOR_H
#include "Monitor.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#include "Monitor.h"
#endif

namespace MM
{
class Atom_group;
class Text;

class Monitor_frame : public Monitor, protected DbC
{
    int                                 collected_;
    int                                 counter_;
    int                                 period_;
    Array_of_own <Monitor_presentation> presentation_;
    Monitor_presentation *              file_presentation_;
    Monitor_presentation *              graph_presentation_;
    Text                                in_;
    bool                                is_on_;

public:
    explicit Monitor_frame (Text in)
    :   collected_(0), counter_(0), period_(100),
        file_presentation_(0), graph_presentation_(0), in_(in), is_on_(true) { }

   ~Monitor_frame ()
        {collected_=0; counter_=0; period_= 0;
         file_presentation_= 0; graph_presentation_= 0;}

   Text                    in      () const    {return in_;}

    virtual bool            is_on   () const  {return is_on_;}
    virtual void            turn_on (bool on) {is_on_ = on;}

    virtual void            show ()
    {
        if (has_graph_presentation ())
        {
            Monitor_presentation & presentation = graph_presentation();
            presentation.show();
        }
    }

    virtual void            update ()
    {
        if (has_graph_presentation ())
        {
            Monitor_presentation & presentation = graph_presentation();
            presentation.update();
        }
    }

    virtual void            execute();
    virtual void            clear();

//    virtual Text            class_name () const =0;
//    virtual MD_monitor *    clone (Atom_group & atom_group,
//                                   Text const & args) const =0;
    int                     collected () const              {return collected_;}
    int                     count     () const              {return counter_;}
    int                     observation_period     () const;
    void                    set_observation_period (int p);

    bool                    has_file_presentation  () const;
    Monitor_presentation &  file_presentation  ();
    Monitor_presentation const &
                            file_presentation  () const;
    void                    new_file_presentation   (Text const& filename);
    void                    adopt_file_presentation (Monitor_presentation *pr);

    bool                    has_graph_presentation () const;
    Monitor_presentation &  graph_presentation ();
    Monitor_presentation const &
                            graph_presentation () const;
    void                    new_graph_presentation   (Text const& graphname);
    void                    adopt_graph_presentation (Monitor_presentation *pr);

    int                     presentation_count () const {return presentation_.size();}
    Monitor_presentation &  presentation(int i)       {return presentation_[i];}
    Monitor_presentation const&
                            presentation(int i) const {return presentation_[i];}
    void                    adopt_presentation (Monitor_presentation *pr);
    void                    eliminate_presentation (Monitor_presentation &pr);

protected:
    virtual void            handle_execute() =0;
    virtual Monitor_presentation *
                            create_file_presentation  (Text const& filename) =0;
    virtual Monitor_presentation *
                            create_graph_presentation (Text const& graphname) =0;
};

}//MM

#endif //MONITOR_FRAME_H
