#ifndef PRESSURE_H
#define PRESSURE_H

#ifndef FUNCTION_H
#include "Function.h"
#endif

namespace MM
{
class Model;

class Pressure : public Function
{
    Model const &           model_;

    //double                  R_cutoff_;
    double                  correction_;

public:
    explicit Pressure (Model const & model) : model_(model), correction_(0.) {}

    virtual double value() const;
    virtual double correction () const;
    virtual void   set_correction (double v);
};

}//MM

#endif //PRESSURE_H
