#include "Pressure_unit.h"

#include "Flaw.h"

namespace MM
{

Unit * Pressure_unit::
clone () const
{
    Pressure_unit *result   = new Pressure_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Pressure_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "Pa")
        return Pa ();

    else if (current_type == "kcal/mol*A3")
        return kcalImolA3 ();

    else if (current_type == "atm")
        return atm ();

    else if (current_type == "at")
        return at ();

    else if (current_type == "bar")
        return bar ();

    else if (current_type == "torr")
        return torr ();

    else
        FLAW (Text() + "Unknown Pressure_unit '" + current_type + "'.");
}

void Pressure_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "Pa")
        set_Pa (new_value);

    else if (current_type == "kcal/mol*A3")
        set_kcalImolA3 (new_value);

    else if (current_type == "atm")
        set_atm (new_value);

    else if (current_type == "at")
        set_at (new_value);

    else if (current_type == "bar")
        set_bar (new_value);

    else if (current_type == "torr")
        set_torr (new_value);

    else
        FLAW (Text() + "Unknown Pressure_unit '" + current_type + "'.");
}

Text const& Pressure_unit::
type (int n)  const
{
    static const Text Pa         = "Pa";
    static const Text kcalImolA3 = "kcal/mol*A3";
    static const Text atm        = "atm";
    static const Text at         = "at";
    static const Text bar        = "bar";
    static const Text torr       = "torr";

    switch (n)
    {
    case 0: return Pa;
    case 1: return kcalImolA3;
    case 2: return atm;
    case 3: return at;
    case 4: return bar;
    case 5: return torr;

    default: FLAW ("Out of range.");
    }
}

}//MM
