#ifndef PRESSURE_UNIT_H
#define PRESSURE_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Pressure_unit : public Unit
{
    double  value_;     // Pa   (N/m2)

public:
    explicit        Pressure_unit () : value_(0.) {set_current_type("Pa");}
    Unit *          clone () const;

    // C
    double          Pa     () const       {return   value_;}
    Pressure_unit & set_Pa (double value) {value_ = value; return *this;}

    // AKMA
    double          kcalImolA3     () const       {return   value_/6.951e9;}
    Pressure_unit & set_kcalImolA3 (double value) {value_ = 6.951e9*value; return *this;}

    // atmosphere
    double          atm     () const        {return   9.8692e-6*value_;}
    Pressure_unit & set_atm (double value)  {value_ = value/9.8692e-6; return *this;}

    // technical atmosphere
    double          at      () const        {return   1.0197e-5*value_;}
    Pressure_unit & set_at  (double value)  {value_ = value/1.0197e-5; return *this;}

    // bar
    double          bar     () const        {return   1.0e-5*value_;}
    Pressure_unit & set_bar (double value)  {value_ = value/1.0e-5; return *this;}

    // torr
    double          torr    () const        {return   7.5006e-3*value_;}
    Pressure_unit & set_torr(double value)  {value_ = value/7.5006e-3; return *this;}


    // Unit interface
    double          value_of_type (Text const & current_type) const;
    void            set_value_of_type (double new_value, Text const & current_type);

    int             type_count () const         {return 6;}
    Text const&     type (int n)  const;
};

}//MM

#endif //PRESSURE_UNIT_H
