#include "RMS_gradient.h"

#include "Model.h"
#include "Atom.h"
#include "Atom_kit.h"

#include <math.h>

namespace MM
{

double RMS_gradient::
value () const
{
    double result = 0.;
    double count = model_.atom_count();

    if (count == 0)
        return 0.;

    for (int i=0;  i<count;  ++i)
    {
        result += model_.atom(i).kit().potential_force().length_2();
    }

    return sqrt (result/(3*count));
}

}//MM
