#ifndef SI_SYSTEM_OF_UNITS_H
#define SI_SYSTEM_OF_UNITS_H

#ifndef SYSTEM_OF_UNITS_H
#include "System_of_Units.h"
#endif

namespace MM
{

class SI_System_of_Units : public System_of_Units
{
public:
    double      Boltzmann_constant () const                                     {return 1.380650424e-23;} // J/K
    double      gas_constant () const                                           {return 8.31447215;} // j mol-1 K-1

    double      length  (Length_unit   const & v) const                         {return v.m();}
    double      energy  (Energy_unit   const & v) const                         {return v.JImol();}
    double      mass    (Mass_unit     const & v) const                         {return v.kg();}
    double      charge  (Charge_unit   const & v) const                         {return v.C();}
    double      time    (Duration_unit const & v,
                                  double * step_length = 0) const
    {
        double result = v.sec ();
        if (step_length != 0)
        {
            *step_length = result / v.steps();
        }
        return result;
   }
    double      force   (Force_unit    const & v) const                         {return v.N();}
    double      pressure(Pressure_unit const & v) const                         {return v.Pa();}
    //double      electric_conversion_factor() const = 0;
    double      temperature  (Temperature_unit const &v) const                  {return v.K();}

    void        set_length (Length_unit & result,   double v) const             {result.set_m (v);}
    void        set_energy (Energy_unit & result,   double v) const             {result.set_JImol (v);}
    void        set_mass   (Mass_unit   & result,   double v) const             {result.set_kg (v);}
    void        set_charge (Charge_unit & result,   double v) const             {result.set_C (v);}
    void        set_time (Duration_unit & result, double v, double steps) const
    {
        result.set_sec (v); 
        double ps          = result.ps ();
        double step_length = ps / steps;
        result.set_step_length_ps (step_length);
        //result.set_steps (steps);
    }
    void        set_force  (Force_unit  & result,   double v) const             {result.set_N (v);}
    void        set_pressure(Pressure_unit & result,double v) const             {result.set_Pa (v);}
    void        set_temperature (Temperature_unit & result, double v) const     {result.set_K (v);}
};

}//MM

#endif //SI_SYSTEM_OF_UNITS_H
