#include "Temperature.h"

#include "Atom_group.h"
#include "Atom.h"
#include "Atom_kit.h"
#include "System_of_Units.h"
#include "Mass_center.h"
#include "Point_3D_impl.h"
#include "Vector_3D_impl.h"

namespace MM
{

double Temperature::
value() const
{
    int     count = atom_group_.atom_count();
    double  sum = 0.;

    const Mass_center mc (const_cast<Atom_group &>(atom_group_));
    double mass;
    Point_3D_impl   position(0,0,0);
    Vector_3D_impl  velocity(0,0,0);
    mc.evaluate (position, &mass, &velocity);

    double velocity_2 = velocity.length_2();
    double K_mc = mass * velocity_2;

    for (int i=0;  i<count;  ++i)
    {
        Atom const & atom = atom_group_.atom (i);
        double mass = atom.mass();
        double velocity_2 = atom.kit().velocity().length_2();
        sum += mass * velocity_2;
    }

    sum -= K_mc;
    double kB = System_of_Units::singleton().gas_constant();
    return  sum / ((3. * count - 3.) * kB);
}

}//MM
