#include "Temperature_unit.h"

#include "Defs.h"
#include "Flaw.h"

namespace MM
{
Temperature_unit::
Temperature_unit ()
:
    value_(Constant::normal_temperature)
    //value_(100)
{
    set_current_type("K");
}

Unit * Temperature_unit::
clone () const
{
    Temperature_unit *result   = new Temperature_unit;
    result->current_type_ = current_type_;
    result->value_        = value_;
    return result;
}

double Temperature_unit::
value_of_type (Text const & current_type) const
{
    if      (current_type == "K")
        return K ();

    else if (current_type == "deg")
        return deg ();

    else
        FLAW (Text() + "Unknown Temperature_unit '" + current_type + "'.");
}

void Temperature_unit::
set_value_of_type (double new_value, Text const & current_type)
{
    if      (current_type == "K")
        set_K (new_value);

    else if (current_type == "deg")
        set_deg (new_value);

    else
        FLAW (Text() + "Unknown Temperature_unit '" + current_type + "'.");
}

Text const& Temperature_unit::
type (int n)  const
{
    static const Text K   = "K";
    static const Text deg = "deg";

    switch (n)
    {
    case 0: return K;
    case 1: return deg;

    default: FLAW ("Out of range.");
    }
}

}//MM
