#ifndef TEMPERATURE_UNIT_H
#define TEMPERATURE_UNIT_H

#ifndef UNIT_H
#include "Unit.h"
#endif

namespace MM
{

class Temperature_unit : public Unit
{
    double  value_;     // K

public:
    explicit            Temperature_unit ();
    Unit *              clone () const;

    double              K     () const          {return   value_;}
    Temperature_unit &  set_K (double value)    {value_ = value; return *this;}

    double              deg   () const          {return  -273.15 + value_;}

    Temperature_unit &  set_deg (double value)
                            {value_ = 273.15 + value; return *this;}

    // Unit interface
    double      value_of_type (Text const & current_type) const;
    void        set_value_of_type (double new_value, Text const & current_type);

    int         type_count () const         {return 2;}
    Text const& type (int n)  const;
};

}//MM

#endif //TEMPERATURE_UNIT_H
