#ifndef TORSION_ANGLE_H
#define TORSION_ANGLE_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef DIHEDRAL_ANGLE_H
#include "Dihedral_angle.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{

class Torsion_angle : public Dihedral_angle, protected DbC
{
    const Atom & atom1_;
    const Atom & atom2_;
    const Atom & atom3_;
    const Atom & atom4_;

public:    
    Torsion_angle (Atom const & atom1,
                   Atom const & atom2,
                   Atom const & atom3,
                   Atom const & atom4 );

    const Atom &    first_atom () const     {return atom1_;}
    const Atom &    second_atom() const     {return atom2_;}
    const Atom &    third_atom () const     {return atom3_;}
    const Atom &    fourth_atom() const     {return atom4_;}
};

}//MM

#endif //TORSION_ANGLE_H
