#ifndef TORSION_LIST_H
#define TORSION_LIST_H

#ifndef ARRAY_H
#include "Array.h"
#endif

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#include <set>

namespace MM
{
class Model;
class Molecule;
class Residue;
class Atom;
class Atom_group;

class Torsion_list : protected DbC
{
    Array <Text>        torsion_type_;
    Array <double>      value_;
    Array <Text>        residue_ID_;

    std::set <Text>     residue_;
    Text                current_residue_;
    int                 torsion_n_;

public:
    int                 torsion_count () const  {return torsion_type_.size();}

    int                 residue_count    () const;
    void                first_torsion    (int residue_n);
    void                next_torsion     ();
    bool                is_valid_torsion () const;
    void                current_torsion  (Text   & torsion_type,
                                          double & value) const;

    void                add (Text const &   torsion_type,
                             double         value,
                             Text const &   residue_ID);

    void                clear();

    void                apply (Model    & model);
    void                apply (Molecule & mol, int res_n, int item_n);

protected:
    Residue &           residue (Model & model, Text const& local_ID);

    void                set_torsion (Atom_group & group, 
                                     Text const&  torsion_type, 
                                     double       value);

    void                set_joint_torsion (Molecule & mol, 
                                           int        res_n, 
                                           double     value);

    void                set_torsion (Atom & atom_1, Atom & atom_2, 
                                     Atom & atom_3, Atom & atom_4, 
                                     double value);

    void                the_same_type (Atom const& atom1, 
                                       Atom const& atom_2, 
                                       Text const& fine_type,
								       Text const& word);
};

}//MM

#endif //TORSION_LIST_H
