#if defined WIN32
#pragma warning(disable: 4786)
#endif

#include "Torsion_type.h"

namespace MM
{
Torsion_type & Torsion_type::
singleton ()
{
    static Torsion_type instance;
    return instance;
}

void Torsion_type::
add (Text const & type,
     Text const & atom_1, Text const & atom_2,
     Text const & atom_3, Text const & atom_4)
{
    singleton().map_[type] = Torsion_type::Tuple (atom_1, atom_2, atom_3, atom_4);
}

void Torsion_type::
get (Text const & type,
    Text & atom_1, Text & atom_2, Text & atom_3, Text & atom_4)
{
    Tuple const & tuple = singleton().map_[type];
    atom_1 = tuple.a1_;
    atom_2 = tuple.a2_;
    atom_3 = tuple.a3_;
    atom_4 = tuple.a4_;
}

}//MM
