#ifndef UNIT_H
#define UNIT_H

#ifndef TEXT_H
#include "Text.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

namespace MM
{
//class Text;

class Unit : protected DbC
{
    bool            definite_flag_;

protected:
    mutable Text    current_type_;

public:
    Unit ();
    virtual Unit *  clone () const =0;

    Text const &    current_type () const               {return current_type_;}      //fix to current_unit
    void            set_current_type (Text const &type) const
    {
        REQUIRE ("Correct type.", correct (type));
        //double old_value = value ();
        //Text   old_type  = current_type ();
        current_type_ = type;
        //set_value (old_value, old_type);
    }

    bool        is_definite  () const       {return definite_flag_;}
    void        set_definite (bool on)      {definite_flag_ = on;}
    bool        from_text    (Text const& str);
    Text        text         () const;

    double      value () const      {return value_of_type (current_type ());}
    void        set_value (double value)
                                    {set_value_of_type (value, current_type());}

    //bool            has_correct_type () const {}
/*    {
        int count = type_count();

        for (int i=0;  i<count;  ++i)
        {
            if (type (i) == current_type)
                return
        }
    }//*/
//    void            add_value (Text & text){text += double;}

    virtual double      value_of_type (Text const & type) const =0;
    virtual void        set_value_of_type (double value, Text const & type) =0;

    virtual int         type_count () const =0;
    virtual Text const& type (int n)  const =0;

protected:
    bool                correct (Text const & current_type) const
    {
        int count = type_count();

        for (int i=0;  i<count;  ++i)
        {
            if (type (i) == current_type)
                return true;
        }

        return false;
    }
};

}//MM

#endif //UNIT_H
