#ifndef VALENT_ANGLE_H
#define VALENT_ANGLE_H

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef ANGLE_H
#include "Angle.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{

class Valent_angle : public Angle, protected DbC
{
    Atom const &    atom1_;
    Atom const &    atom2_;
    Atom const &    atom3_;

public:
    Valent_angle (Atom const & atom1,
                  Atom const & atom2,
                  Atom const & atom3);

    Atom const &    first_atom () const             {return atom1_;}
    Atom const &    second_atom() const             {return atom2_;}
    Atom const &    third_atom () const             {return atom3_;}
};

}//MM

#endif //VALENT_ANGLE_H
