#ifndef BOUNDARY_CONDITIONS_H
#define BOUNDARY_CONDITIONS_H

#ifndef BOX_H
#include "Box.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef EVENT_H
#include "Event.h"
#endif

#ifndef MODEL_EVENT_H
#include "Model_event.h"
#endif

namespace MM
{
class Model;
class Model_kit;

class Boundary_conditions : protected DbC
{
    Model &         model_;
    Text            type_;

    Box *           box_;
    Own <Box>       box_janitor_;
    bool            is_auto_box_;
    bool            is_auto_box_valid_;
    Event           auto_box_recalculated_;

public:
    explicit        Boundary_conditions (Model_kit & kit);
                   ~Boundary_conditions ();
    
    Model &         model ()         {return model_;}

    // Mutual exclusive: Vacuum, Box, Spherical
    Text const &    type_name () const;
    void            set_type (Text const & new_type);
    void            update (Model_event::Hint hint);

    bool            is_a_box () const                                           {return type_=="Box" && box_ != 0;}
    Box &           box ();
    Box const &     box () const;
    bool            is_box_a_crystal_cell        () const;
    bool            is_auto_box                  () const;
    void            accept_crystal_cell_as_a_box ();
    void            reject_crystal_cell_as_a_box ();
    void            set_box                      (Box & new_box);
    void            adopt_box                    (Box * adoptee);
    void            set_auto_box                 (bool on);
    void            recalculate_auto_box         ();
    void            when_auto_box_recalculated   (Command *to_do, bool on);
    // vacuum ()
    // ...
};

}//MM

#endif //BOUNDARY_CONDITIONS_H
