#ifndef BOX_H
#define BOX_H

#ifndef VECTOR_3D_H
#include "Vector_3D.h"
#endif

namespace MM
{
class Point_3D;
class Atom_group;

class Box
{
public:
    virtual ~Box () {}
    virtual bool                is_default () const =0;
    virtual bool                is_rectangular () const =0;
    virtual double              volume () const =0;

    virtual Point_3D  const &   o () const =0;
    virtual Vector_3D const &   a () const =0;
    virtual Vector_3D const &   b () const =0;
    virtual Vector_3D const &   c () const =0;

    virtual double              a_mod () const =0;
    virtual double              b_mod () const =0;
    virtual double              c_mod () const =0;

    virtual double              a_mod_rectangle () const =0;
    virtual double              b_mod_rectangle () const =0;
    virtual double              c_mod_rectangle () const =0;

    virtual double              alpha () const =0;
    virtual double              beta  () const =0;
    virtual double              gamma () const =0;

    virtual void                set_o (Point_3D const & new_o) =0;

    virtual void                set (Vector_3D const & new_a,
                                     Vector_3D const & new_b,
                                     Vector_3D const & new_c) =0;

    virtual void                set (double new_a,
                                     double new_b,    
                                     double new_c,
                                     double new_alpha, 
                                     double new_beta, 
                                     double new_gamma) =0;

    virtual void                set (double new_a,
                                     double new_b,    
                                     double new_c) =0;

    virtual void                scale_a (double k) =0;
    virtual void                scale_b (double k) =0;
    virtual void                scale_c (double k) =0;

    enum  Shape {Cube, Cuboid/*, Parallelepiped*/};
    virtual void                fit (Atom_group const &,
                                     Shape = Cube,
                                     double margin = 1.5) =0;
};

}//MM

#endif //BOX_H
