#include "Cleaner.h"

#include "Selector.h"
#include "Model_kit.h"

namespace MM
{

Cleaner::
~Cleaner ()
{
    execute ();
}

void Cleaner::
execute ()
{
    int i;

    if (is_empty())
        return;

    model_.kit().selector().clear_picking();

    for (i=0;  i<bond_.size();  ++i)
        bond_[i].set_dead ();           //fix release

    for (i=0;  i<atom_.size();  ++i)
        atom_[i].set_dead ();

    for (i=0;  i<molecule_.size();  ++i)
        molecule_[i].set_dead ();           //fix release

    for (i=0;  i<residue_.size();  ++i)
        residue_[i].set_dead ();           //fix release

    for (i=0;  i<joint_.size();  ++i)
        joint_[i].set_dead ();           //fix release

    atom_.     clear();
    bond_.     clear();
    molecule_. clear();
    residue_.  clear();
    joint_.    clear();

    model_.remove_deads ();
}

}//MM
