#ifndef CLEANER_H
#define CLEANER_H

#ifndef ATOM_H
#include "Atom.h"
#endif

#ifndef BOND_H
#include "Bond.h"
#endif

#ifndef MOLECULE_H
#include "Molecule.h"
#endif

#ifndef RESIDUE_H
#include "Residue.h"
#endif

#ifndef JOINT_H
#include "Joint.h"
#endif

#ifndef MODEL_H
#include "Model.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{

class Cleaner
{
    Model &                     model_;

    Array_of_ref <Atom>         atom_;
    Array_of_ref <Bond>         bond_;
    Array_of_ref <Molecule>     molecule_;
    Array_of_ref <Residue>      residue_;
    Array_of_ref <Joint>        joint_;

public:
    explicit Cleaner (Model & model) : model_(model) { }
    ~Cleaner ();

    void            add (Atom     & ref) {atom_.    push_back (ref);}
    void            add (Bond     & ref) {bond_.    push_back (ref);}
    void            add (Molecule & ref) {molecule_.push_back (ref);}
    void            add (Residue  & ref) {residue_. push_back (ref);}
    void            add (Joint    & ref) {joint_.   push_back (ref);}

    bool            is_empty () const    {return atom_.    size() == 0 && 
                                                 bond_.    size() == 0 &&
                                                 molecule_.size() == 0 &&
                                                 residue_. size() == 0 &&
                                                 joint_.   size() == 0;}

    void            execute ();
};

}//MM

#endif //CLEANER_H
