#include "Test.h"

#include "Cleaner.h"
#include "Model_impl.h"
#include "Path.h"

namespace MM
{

class Cleaner_test : public Test
{
    Cleaner *link;
public:
    Cleaner_test( const Text & suite_name ) : Test( suite_name ) { }
    
    void run()
    {
        test_bond   ();     count_tests();
    }

    void test_bond    ();
};

Cleaner_test test_cleaner ("correctness");

void Cleaner_test::
test_bond ()
{
    Model_impl model;
    model.load (Path::tests() + "C2.hin", "auto detect");

    TEST("", model.bond_count() == 1);

    Cleaner cleaner (model);
    cleaner.execute();
    TEST("", model.bond_count() == 1);

    cleaner.add (model.bond (0));
    cleaner.execute();

    TEST("", model.bond_count() == 0);
    TEST("", model.atom_count() == 2);

}


}//MM
