#ifndef FIXED_JOINT_H
#define FIXED_JOINT_H

#ifndef POINT_3D_H
#include "Point_3D.h"
#endif

#ifndef JOINT_H
#include "Joint.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

namespace MM
{

class Fixed_joint : public Joint
{
    Own <Point_3D>      first_point_;
    Own <Point_3D>      second_point_;
    Own <Point_3D>      third_point_;

public:    
    Fixed_joint (Point_3D * first_point,
                 Point_3D * second_point,
                 Point_3D * third_point,
                 Atom     & stub_atom,
                 Atom     & terminal_atom,
                 Atom     & directional_atom,
                 Atom_group * adoptee)
    :
        Joint (*first_point, *second_point, *third_point,
                stub_atom, terminal_atom, directional_atom, adoptee),
        first_point_(first_point),
        second_point_(second_point),
        third_point_(third_point)
    {
    }
};

}//MM

#endif //FIXED_JOINT_H
