#ifndef FLOAT_JOINT_H
#define FLOAT_JOINT_H

#ifndef JOINT_H
#include "Joint.h"
#endif

#ifndef ATOM_H
#include "Atom.h"
#endif

namespace MM
{
class Atom;

class Float_joint : public Joint
{
    Atom &     first_atom_;
    Atom &     second_atom_;
    Atom &     third_atom_;

public:
    Float_joint (Atom & first_atom, Atom & second_atom, Atom & third_atom, Atom_group * adoptee)
    :
        Joint (first_atom. position(), 
               second_atom.position(), 
               third_atom. position(),
               first_atom, 
               second_atom, 
               third_atom, 
               adoptee),
        first_atom_ (first_atom), 
        second_atom_(second_atom), 
        third_atom_ (third_atom)    
    {
    }

    Atom &      first_atom  ()      {return first_atom_;}
    Atom &      second_atom ()      {return second_atom_;}
    Atom &      third_atom  ()      {return third_atom_;}

};

}//MM

#endif //FLOAT_JOINT_H
