#ifndef MODEL_EVENT_H
#define MODEL_EVENT_H

#ifndef EVENT_H
#include "Event.h"
#endif

namespace MM
{

class Model_event
{
public:
    enum Hint  {Structure_changed = 0,
                Conformation_changed,
                Force_Field_changed,
                Monitors_changed};

private:
    //Event       structure_changed_;
    //Event       conformation_changed_;
    mutable Event_1 <Hint>      model_changed_;
    bool                        lock_;

public:
    Model_event () : lock_(false) {}

    bool    locked () const {return lock_;}
    void    set_lock (bool on) {lock_ = on;}

    void    structure_changed () const                                          {if (!lock_) model_changed_.publish (Structure_changed);}
    //void    when_structure_changed (Command * to_do, bool on = true);

    void    conformation_changed () const                                       {if (!lock_) model_changed_.publish (Conformation_changed);}
    void    force_field_changed  () const                                       {if (!lock_) model_changed_.publish (Force_Field_changed);}
    //void    when_conformation_changed (Command * to_do, bool on = true);
    void    when_model_changed (Command_1 <Hint> * to_do, bool on = true);
};

}//MM

#endif //MODEL_EVENT_H
