#include "Model_view_composite.h"

#include "Atom.h"
#include "Atom_kit.h"
#include "Bond.h"
#include "Bond_kit.h"
#include "Model.h"

namespace MM
{

Model_view * Model_view_composite::
clone (Model & model, const char * name) const
{
    Model_view_composite *twin = new Model_view_composite (model);
    for (int i=0;  i<view_.size();  ++i)
        twin->adopt (view_[i].clone (model, name));
    return twin;
}

void Model_view_composite::
renew ()
{
    int i, count = model_.atom_count();

    for (i=0;  i<count;  ++i)
        model_.atom (i).kit().visual().renew ();

    count = model_.bond_count();

    for (i=0;  i<count;  ++i)
        model_.bond (i).kit().visual().renew ();
}

}//MM

