#ifndef MODEL_VIEW_COMPOSITE_H
#define MODEL_VIEW_COMPOSITE_H

#ifndef MODEL_VIEW_H
#include "Model_view.h"
#endif

#ifndef ARRAY_OF_OWN_H
#include "Array_of_own.h"
#endif

namespace MM
{

class Model_view_composite : public Model_view
{
    Model &                         model_;
    Array_of_own <Model_view>       view_;

public:
    explicit Model_view_composite (Model & model) : model_(model) { }

    virtual Model_view *clone (Model & model, const char * name) const;

    bool       is_on () const
    {
        bool result = false;
        for (int i=0;  i<view_.size();  ++i)
            result |= view_[i].is_on();
        return result;
    }

    Model &     model () {return model_;}

    int         count () const                {return view_.size();}

    void        fit_to_screen()
    {
        for (int i=0;  i<view_.size();  ++i)
            view_[i].fit_to_screen();
    }

    void        flush_camera ()
    {
        for (int i=0;  i<view_.size();  ++i)
            view_[i].flush_camera();
    }

    void  set_level_of_details (int lod)
    {
        for (int i=0;  i<view_.size();  ++i)
            view_[i].set_level_of_details (lod);
    }

    void set_focus ()
    {
        for (int i=0;  i<view_.size();  ++i)
            view_[i].set_focus ();
    }

    void renew ();

    void        adopt (Model_view * adoptee)
    {
        view_.push_back (adoptee);
    }

    Model_view * orphan (Model_view * adoptee)
    {
        return view_.orphan (*adoptee);
    }
};

}//MM

#endif //MODEL_VIEW_COMPOSITE_H
