#include "Replica.h"

#include "Model_kit.h"
#include "Atom_kit.h"

namespace MM
{
Temperature_unit Replica::
desired_temperature () const //fix  Temperature_unit(Temperature_unit&)
{
    Temperature_unit result;
    result.set_K (desired_temperature_.K());
    return result;
}

void Replica::
set_desired_temperature (Temperature_unit const & t)
{
    desired_temperature_.set_K(t.K());
}

void Replica::
set_force_field (Text const & v)
{
    Model & model = kit().model();
    force_field_.adopt (new Force_field (v));

    int count = model.atom_count();

    for (int i=0;  i<count;  ++i)
    {
        Atom     & atom = model.atom(i);
        Atom_kit & kit  = atom.kit();

        if (kit.has_fine_type())
        {
            double charge = 12345;
            char const * type = Fine_type::to 
                (kit.fine_type_name(), force_field_().name().c_str(), &charge);
            if (type == 0)
                continue;
            kit.set_mm_type (type);

            kit.set_ff_mass (mot().mass (kit.mm_type ()));
            
            if (charge != 12345)
                atom.set_charge (charge);

            if (force_field_().induction_charge(kit.mm_type ()).was_defined())
            {
                kit.set_induction_charge 
                    (force_field_().induction_charge(kit.mm_type ()).value());
            }
            else
                kit.set_induction_charge (atom.charge ());
        }
    }

     kit().event().force_field_changed ();
}

}//MM
