#ifndef REPLICA_H
#define REPLICA_H

#ifndef TEMPERATURE_UNIT_H
#include "Temperature_unit.h"
#endif

#ifndef FORCE_FIELD_H
#include "Force_field.h"
#endif

#ifndef OWN_H
#include "Own.h"
#endif

#ifndef DBC_H
#include "DbC.h"
#endif

#ifndef MODEL_H
#include "Model.h"
#endif

#ifndef MODEL_EVENT_H
#include "Model_event.h"
#endif

namespace MM
{
class Model;
class Model_kit;

class Replica : protected DbC
{
    Model_kit &                         kit_;
    Temperature_unit                    desired_temperature_;
    Own <Force_field>                   force_field_;

public:
    explicit    Replica (Model_kit & kit) : kit_(kit), force_field_(new Force_field) {}

//    Model &                 model ()                                            {return kit_.model_;}
//    Model const &           model () const                                      {return kit_.model_;}
    Model_kit &             kit ()                                              {return kit_;}
    Model_kit const &       kit () const                                        {return kit_;}

    Temperature_unit        desired_temperature () const //fix  Temperature_unit(Temperature_unit&)
    ;
    void                    set_desired_temperature (Temperature_unit const & t);

    bool                    has_force_field  () const                           {return force_field_.is_valid();}
    Force_field &           force_field  ()                                     {REQUIRE ("", has_force_field  ()); return force_field_();}
    Force_field const &     force_field  () const                               {REQUIRE ("", has_force_field  ()); return force_field_();}
    void                    set_force_field   (Text const &);
};

}//MM

#endif //REPLICA_H
