#ifndef RIGID_BODY_H
#define RIGID_BODY_H

namespace MM
{
class Joint;
class Fixed_joint;
class Float_joint;

class Rigid_body
{
public:
    virtual ~Rigid_body(){}

    virtual int                 joint_count () const =0;
    virtual Joint &             joint       (int i)  =0;
    virtual const Joint &       joint       (int i) const =0;
    virtual void                erase       (Joint & ref) =0;

    virtual int                 fixed_joint_count () const =0;
    virtual Fixed_joint &       fixed_joint       (int i)  =0;
    virtual const Fixed_joint & fixed_joint       (int i) const =0;
    virtual void                add_joint         (Fixed_joint * adoptee) =0;

    virtual int                 float_joint_count () const =0;
    virtual Float_joint &       float_joint       (int i)  =0;
    virtual const Float_joint & float_joint       (int i) const =0;
    virtual void                add_joint         (Float_joint * adoptee) =0;
};

}//MM

#endif //RIGID_BODY_H
