#ifndef RIGID_BODY_IMPL_H
#define RIGID_BODY_IMPL_H

#ifndef RIGID_BODY_H
#include "Rigid_body.h"
#endif

#ifndef JOINT_H
#include "Joint.h"
#endif

#ifndef FIXED_JOINT_H
#include "Fixed_joint.h"
#endif

#ifndef FOLAT_JOINT_H
#include "Float_joint.h"
#endif

#ifndef ARRAY_OF_REF_H
#include "Array_of_ref.h"
#endif

namespace MM
{

class Rigid_body_impl : public Rigid_body
{
    Array_of_ref <Joint>        joints_; //fix to set?
    Array_of_own <Fixed_joint>  fixed_joints_;
    Array_of_own <Float_joint>  float_joints_;

public:
    int                         joint_count() const {return joints_.size();}
    Joint &                     joint (int i)       {return joints_[i];}
    const Joint &               joint (int i) const {return joints_[i];}
    void                        erase (Joint & ref);

    int                         fixed_joint_count() const {return fixed_joints_.size();}
    Fixed_joint &               fixed_joint (int i)       {return fixed_joints_[i];}
    const Fixed_joint &         fixed_joint (int i) const {return fixed_joints_[i];}
    void                        add_joint (Fixed_joint * adoptee);

    int                         float_joint_count() const {return float_joints_.size();}
    Float_joint &               float_joint (int i)       {return float_joints_[i];}
    const Float_joint &         float_joint (int i) const {return float_joints_[i];}
    void                        add_joint (Float_joint * adoptee);
};

}//MM

#endif //RIGID_BODY_IMPL_H
