#ifndef SELECTOR_H
#define SELECTOR_H

#ifndef EVENT_H
#include "Event.h"
#endif

#include <queue>

namespace MM
{
class Atom;
class Bond;
class Model;

class Selector
{
    enum Mode {New, Add};

    static Mode                         mode_;

    Model &                             model_;
    std::queue <Atom*>                  pick_queue_;
    static int                          max_picked_atoms_;
    static bool                         numerate_atoms_flag_;
    static Event_1 <Atom&>              atom_picked_;
    int                                 version_;

public:
    static Mode &       mode ()                 {return mode_;}
    static void         set_mode (Mode & mode)  {mode_ = mode;}

    Selector (Model & model) : model_(model), version_(0) { }

    Model &             model ()                {return model_;}

    static int          set_max_picked_atoms (int max);
    static void         numerate_atoms (bool on) {numerate_atoms_flag_ = on;}
    static void         when_atom_picked (Command_1 <Atom&> *adoptee, bool on);

    void                select (Atom &, bool);  //fix
    void                select (Bond &, bool);  //fix
    void                clear ();
    void                invert_all ();
    int                 version () const    {return version_;}

    void                pick   (Atom &);
    void                pick   (Bond &);

    int                 pick_count() const {return pick_queue_.size();}
    Atom  &             last_picked ()   {return *pick_queue_.front();}
    void                clear_picking ();

//protected:
    void                pop ();
};

}//MM

#endif //SELECTOR_H
