#ifndef ATOM_GROUP_CONFIGURATION_H
#define ATOM_GROUP_CONFIGURATION_H

#ifndef COORDINATES_FRAME_H
#include "Coordinates_frame.h"
#endif

//#ifndef FORCE_H
//#include "Force.h"
//#endif

#ifndef INTERACTION_H
#include "Interaction.h"
#endif

namespace MM
{

class Atom_group_configuration : public Coordinates_frame
{
    Interaction *           interaction_;
//    Force *                 force_;

public:
    //explicit Atom_group_configuration (Atom_group & group)
    //:   Coordinates_frame (group) { }

    explicit Atom_group_configuration
        (Atom_group & group, Interaction & interaction)
    :   Coordinates_frame (group), interaction_(&interaction) { }

//    virtual void            after_change_update (Interaction & interaction){}

    void    set (double const* new_values)
    {
        Coordinates_frame::set(new_values);
        update_interactions ();
    }

    void    add (double const* values)
    {
        Coordinates_frame::add(values);
        update_interactions ();
    }

protected:
    void    update_interactions ()
    {
        for (int i=0;  i<group_.atom_count(); ++i)
        {
            group_.atom(i).kit().set_velocity (Vector_3D_impl (0,0,0));
        }

        interaction_->add_force ();
    }
};

}//MM

#endif //ATOM_GROUP_CONFIGURATION_H
