#ifndef COMPONENT_H
#define COMPONENT_H

#ifndef MODEL_H
#include "Model.h"
#endif

#ifndef VIEW_H
#include "View.h"
#endif

#ifndef CONTROLLER_H
#include "Controller.h"
#endif

namespace MM
{

class Component
{
public:    
    virtual ~Component();
    virtual Component * clone() const =0;

    virtual void set_model( Model * model ) = 0;
    virtual void set_view( View * view ) = 0;
    virtual void set_controller( Controller * controller ) = 0;
};

}//MM

#endif //COMPONENT_H
